---
title: Test your exposed credentials checks configuration · Cloudflare Web
  Application Firewall (WAF) docs
description: After enabling and configuring exposed credentials checks, you may
  want to test if the checks are working properly.
lastUpdated: 2025-09-12T15:50:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/managed-rules/check-for-exposed-credentials/test-configuration/
  md: https://developers.cloudflare.com/waf/managed-rules/check-for-exposed-credentials/test-configuration/index.md
---

After enabling and configuring exposed credentials checks, you may want to test if the checks are working properly.

Recommendation: Use leaked credentials detection instead

Cloudflare recommends that you use [leaked credentials detection](https://developers.cloudflare.com/waf/detections/leaked-credentials/) instead of Cloudflare Exposed Credentials Check, which refers to a previous implementation.\
For more information on upgrading your current Exposed Credentials Check configuration, refer to the [upgrade guide](https://developers.cloudflare.com/waf/managed-rules/check-for-exposed-credentials/upgrade-to-leaked-credentials-detection/).

Cloudflare provides a special set of case-sensitive credentials for this purpose:

* Login: `CF_EXPOSED_USERNAME` or `CF_EXPOSED_USERNAME@example.com`
* Password: `CF_EXPOSED_PASSWORD`

The WAF always considers these specific credentials as having been previously exposed. Use them to force an "exposed credentials" event, which allows you to check the behavior of your current configuration.
