---
title: Example mitigation rules · Cloudflare Web Application Firewall (WAF) docs
description: "The following example custom rule will block requests with an LLM
  prompt that tries to obtain PII of a specific category:"
lastUpdated: 2025-11-06T19:39:43.000Z
chatbotDeprioritize: false
tags: AI
source_url:
  html: https://developers.cloudflare.com/waf/detections/firewall-for-ai/example-rules/
  md: https://developers.cloudflare.com/waf/detections/firewall-for-ai/example-rules/index.md
---

## Block requests with specific PII category in LLM prompt

The following example [custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) will block requests with an LLM prompt that tries to obtain PII of a specific [category](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.pii_categories/):

* **When incoming requests match**:

  | Field | Operator | Value |
  | - | - | - |
  | LLM PII Categories | is in | `Credit Card` |

  If you use the Expression Editor, enter the following expression:\
  `(any(cf.llm.prompt.pii_categories[*] in {"CREDIT_CARD"}))`

* **Action**: *Block*

## Block requests with specific unsafe content categories in LLM prompt

The following example [custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) will block requests with an LLM prompt containing unsafe content of specific [categories](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.unsafe_topic_categories/):

* **When incoming requests match**:

  | Field | Operator | Value |
  | - | - | - |
  | LLM Unsafe topic categories | is in | `S1: Violent Crimes` `S10: Hate` |

  If you use the Expression Editor, enter the following expression:\
  `(any(cf.llm.prompt.unsafe_topic_categories[*] in {"S1" "S10"}))`

* **Action**: *Block*

## Block requests with prompt injection attempt in LLM prompt

The following example [custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) will block requests with an [injection score](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.injection_score/) below `20`. Using a low injection score value in the rule helps avoid false positives.

* **When incoming requests match**:

  | Field | Operator | Value |
  | - | - | - |
  | LLM Injection score | less than | `20` |

  If you use the Expression Editor, enter the following expression:\
  `(cf.llm.prompt.injection_score < 20)`

* **Action**: *Block*
