---
title: DashButton · Cloudflare Style Guide
description: This component creates a LinkButton that links to a Cloudflare
  dashboard deeplink.
lastUpdated: 2025-10-31T14:59:18.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/dash-button/
  md: https://developers.cloudflare.com/style-guide/components/dash-button/index.md
---

This component creates a [LinkButton](https://developers.cloudflare.com/style-guide/components/buttons/) that links to a Cloudflare dashboard deeplink.

While we recommend the use of `DashButton`, you can continue to use deeplinks (as a link, without the component), if necessary.

Where routes are stored

The list of available routes are generated by running a script that we manually trigger periodically. The script outputs the available paths in [`src/content/dash-routes/index.json`](https://github.com/cloudflare/cloudflare-docs/blob/production/src/content/dash-routes/index.json).

The `DashButton` component then uses those routes to automatically generate the list of buttons on this page. The `DashButton` will fail to build if you edit the `url` prop to a route that is not listed in the `index.json` file.

Additionally, each run of the script overwrites the previous `/dash-routes/index.json` file. If you edit the this file manually, it will be overwritten in the next run of the script.

Therefore, only make manual changes to this file if both of the following are true:

* The link is already live in the dashboard.
* The name-change is confirmed, and there's no (or little) chance of rollback.

## Import

## Usage

### Core dashboard

### Zero Trust dashboard

## `<DashButton>` Props

### `url`

**type:** `string`

The Cloudflare dashboard deeplink to navigate to. See the below list for available routes.

### `buttonName`

**type:** `string`

**default:** The name of the route.

Additional name to override the default name of the route.

### `zeroTrust`

**type:** `boolean`

**default:** `false`

Set to `true` to use the [Zero Trust dashboard routes](https://developers.cloudflare.com/style-guide/components/dash-button/#zero-trust-routes) instead of the [Cloudflare dashboard routes](https://developers.cloudflare.com/style-guide/components/dash-button/#core-routes).

## Available routes

### Core Routes

* **Account home**

  ```mdx
  <DashButton url="/?to=/:account/home" />
  ```

* **Analytics & logs > Log Explorer > Log search**

  ```mdx
  <DashButton url="/?to=/:account/log-explorer/log-search" />
  ```

* **Analytics & logs > Log Explorer > Custom dashboards**

  ```mdx
  <DashButton url="/?to=/:account/log-explorer/dashboards" />
  ```

* **Analytics & logs > Log Explorer > Manage datasets**

  ```mdx
  <DashButton url="/?to=/:account/log-explorer/manage-sources" />
  ```

* **Analytics & logs > Account analytics**

  ```mdx
  <DashButton url="/?to=/:account/analytics" />
  ```

* **Analytics & logs > Web analytics**

  ```mdx
  <DashButton url="/?to=/:account/web-analytics" />
  ```

* **Analytics & logs > Trace**

  ```mdx
  <DashButton url="/?to=/:account/trace" />
  ```

* **Analytics & logs > Logpush**

  ```mdx
  <DashButton url="/?to=/:account/logs" />
  ```

* **Compute & AI > Workers & Pages**

  ```mdx
  <DashButton url="/?to=/:account/workers-and-pages" />
  ```

* **Compute & AI > Observability**

  ```mdx
  <DashButton url="/?to=/:account/workers-and-pages/observability" />
  ```

* **Compute & AI > Workers for Platforms**

  ```mdx
  <DashButton url="/?to=/:account/workers-for-platforms" />
  ```

* **Compute & AI > Containers**

  ```mdx
  <DashButton url="/?to=/:account/workers/containers" />
  ```

* **Compute & AI > Durable Objects**

  ```mdx
  <DashButton url="/?to=/:account/workers/durable-objects" />
  ```

* **Compute & AI > Queues**

  ```mdx
  <DashButton url="/?to=/:account/workers/queues" />
  ```

* **Compute & AI > Workflows**

  ```mdx
  <DashButton url="/?to=/:account/workers/workflows" />
  ```

* **Compute & AI > Browser Rendering**

  ```mdx
  <DashButton url="/?to=/:account/workers/browser-rendering" />
  ```

* **Compute & AI > AI Search (AutoRAG)**

  ```mdx
  <DashButton url="/?to=/:account/ai/ai-search" />
  ```

* **Compute & AI > Workers AI**

  ```mdx
  <DashButton url="/?to=/:account/ai/workers-ai" />
  ```

* **Compute & AI > AI Gateway**

  ```mdx
  <DashButton url="/?to=/:account/ai/ai-gateway" />
  ```

* **Compute & AI > VPC**

  ```mdx
  <DashButton url="/?to=/:account/workers/vpc" />
  ```

* **Compute & AI > Workers plans**

  ```mdx
  <DashButton url="/?to=/:account/workers/plans" />
  ```

* **Storage & databases > R2 object storage > Overview**

  ```mdx
  <DashButton url="/?to=/:account/r2/overview" />
  ```

* **Storage & databases > R2 object storage > Data migration**

  ```mdx
  <DashButton url="/?to=/:account/r2/slurper" />
  ```

* **Storage & databases > Hyperdrive**

  ```mdx
  <DashButton url="/?to=/:account/workers/hyperdrive" />
  ```

* **Storage & databases > Workers KV**

  ```mdx
  <DashButton url="/?to=/:account/workers/kv/namespaces" />
  ```

* **Storage & databases > D1 SQL database**

  ```mdx
  <DashButton url="/?to=/:account/workers/d1" />
  ```

* **Storage & databases > Analytics Engine**

  ```mdx
  <DashButton url="/?to=/:account/workers/analytics-engine" />
  ```

* **Storage & databases > Pipelines > Pipelines**

  ```mdx
  <DashButton url="/?to=/:account/pipelines/overview" />
  ```

* **Storage & databases > Pipelines > Streams**

  ```mdx
  <DashButton url="/?to=/:account/pipelines/streams" />
  ```

* **Storage & databases > Pipelines > Sinks**

  ```mdx
  <DashButton url="/?to=/:account/pipelines/sinks" />
  ```

* **Storage & databases > Vectorize**

  ```mdx
  <DashButton url="/?to=/:account/ai/vectorize" />
  ```

* **Storage & databases > Secrets Store**

  ```mdx
  <DashButton url="/?to=/:account/secrets-store" />
  ```

* **Media > Stream > Videos**

  ```mdx
  <DashButton url="/?to=/:account/stream/videos" />
  ```

* **Media > Stream > Live inputs**

  ```mdx
  <DashButton url="/?to=/:account/stream/inputs" />
  ```

* **Media > Stream > Transformations**

  ```mdx
  <DashButton url="/?to=/:account/stream/video-transformations" />
  ```

* **Media > Stream > Analytics**

  ```mdx
  <DashButton url="/?to=/:account/stream/analytics" />
  ```

* **Media > Images > Transformations**

  ```mdx
  <DashButton url="/?to=/:account/images/transformations" />
  ```

* **Media > Images > Hosted images**

  ```mdx
  <DashButton url="/?to=/:account/images/hosted" />
  ```

* **Media > Realtime > RealtimeKit**

  ```mdx
  <DashButton url="/?to=/:account/realtime/kit" />
  ```

* **Media > Realtime > TURN Server**

  ```mdx
  <DashButton url="/?to=/:account/realtime/turn" />
  ```

* **Media > Realtime > Serverless SFU**

  ```mdx
  <DashButton url="/?to=/:account/realtime/sfu" />
  ```

* **Application security > Security insights**

  ```mdx
  <DashButton url="/?to=/:account/security-center" />
  ```

* **Application security > Security analytics**

  ```mdx
  <DashButton url="/?to=/:account/security-center/analytics" />
  ```

* **Application security > Security events**

  ```mdx
  <DashButton url="/?to=/:account/security-center/events" />
  ```

* **Application security > WAF**

  ```mdx
  <DashButton url="/?to=/:account/application-security/waf" />
  ```

* **Application security > Investigate**

  ```mdx
  <DashButton url="/?to=/:account/security-center/investigate" />
  ```

* **Application security > Infrastructure**

  ```mdx
  <DashButton url="/?to=/:account/security-center/inventory" />
  ```

* **Application security > Threat intelligence**

  ```mdx
  <DashButton url="/?to=/:account/security-center/threat-intelligence" />
  ```

* **Application security > Brand protection**

  ```mdx
  <DashButton url="/?to=/:account/security-center/brand-protection" />
  ```

* **Application security > Security reports**

  ```mdx
  <DashButton url="/?to=/:account/security-center/reports" />
  ```

* **Application security > Turnstile**

  ```mdx
  <DashButton url="/?to=/:account/turnstile" />
  ```

* **Zero Trust**

  ```mdx
  <DashButton url="https://one.dash.cloudflare.com" />
  ```

* **Networking > Analytics > Network analytics**

  ```mdx
  <DashButton url="/?to=/:account/network-analytics" />
  ```

* **Networking > Analytics > Magic monitoring**

  ```mdx
  <DashButton url="/?to=/:account/network-monitoring" />
  ```

* **Networking > Magic Transit > Configuration**

  ```mdx
  <DashButton url="/?to=/:account/magic-transit/configuration" />
  ```

* **Networking > Magic Transit > Network health**

  ```mdx
  <DashButton url="/?to=/:account/magic-transit/tunnel-healthchecks" />
  ```

* **Networking > Magic Transit > Packet captures**

  ```mdx
  <DashButton url="/?to=/:account/magic-transit/packet-captures/captures" />
  ```

* **Networking > Magic WAN > Network overview**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/network" />
  ```

* **Networking > Magic WAN > Connector on-ramps**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/mconn-onramp" />
  ```

* **Networking > Magic WAN > Cloud on-ramps**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/cloud-onramp" />
  ```

* **Networking > Magic WAN > Configuration**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/configuration" />
  ```

* **Networking > Magic WAN > Network health**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/tunnel-healthchecks" />
  ```

* **Networking > Magic WAN > Packet captures**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/packet-captures/captures" />
  ```

* **Networking > Magic Firewall**

  ```mdx
  <DashButton url="/?to=/:account/network-security/magic_firewall" />
  ```

* **Networking > L3/4 DDoS protection > DDoS Managed Rules**

  ```mdx
  <DashButton url="/?to=/:account/network-security/ddos" />
  ```

* **Networking > Interconnects**

  ```mdx
  <DashButton url="/?to=/:account/interconnects" />
  ```

* **Networking > Cloud Integrations**

  ```mdx
  <DashButton url="/?to=/:account/mcn/integrations" />
  ```

* **Networking > IP addresses > Leased IPs**

  ```mdx
  <DashButton url="/?to=/:account/ip-addresses/leased-ips" />
  ```

* **Networking > IP addresses > Address maps**

  ```mdx
  <DashButton url="/?to=/:account/ip-addresses/proxy-ips" />
  ```

* **Networking > Internal DNS**

  ```mdx
  <DashButton url="/?to=/:account/internal-dns" />
  ```

* **Networking > DNS Firewall > Clusters**

  ```mdx
  <DashButton url="/?to=/:account/dns-firewall/clusters" />
  ```

* **Networking > DNS Firewall > Analytics**

  ```mdx
  <DashButton url="/?to=/:account/dns-firewall/analytics" />
  ```

* **Delivery & performance > Bulk redirects**

  ```mdx
  <DashButton url="/?to=/:account/bulk-redirects" />
  ```

* **Delivery & performance > Load Balancing**

  ```mdx
  <DashButton url="/?to=/:account/load-balancing" />
  ```

* **Delivery & performance > Web tag management > Tag setup**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/zaraz" />
  ```

* **Delivery & performance > Web tag management > Consent**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/consent" />
  ```

* **Delivery & performance > Web tag management > History**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/history" />
  ```

* **Delivery & performance > Web tag management > Monitoring**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/monitoring" />
  ```

* **Delivery & performance > Web tag management > Settings**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/settings" />
  ```

* **Delivery & performance > Web tag management > Zaraz plans**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/plans" />
  ```

* **Delivery & performance > Web tag management > Google Tag Gateway**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/google-tag-gateway" />
  ```

* **Domain registration > Manage domains**

  ```mdx
  <DashButton url="/?to=/:account/registrar/domains" />
  ```

* **Domain registration > Transfer domains**

  ```mdx
  <DashButton url="/?to=/:account/registrar/transfer" />
  ```

* **Domain registration > Register domains**

  ```mdx
  <DashButton url="/?to=/:account/registrar/register" />
  ```

* **Manage account > Members**

  ```mdx
  <DashButton url="/?to=/:account/members" />
  ```

* **Manage account > Billing**

  ```mdx
  <DashButton url="/?to=/:account/billing" />
  ```

* **Manage account > Account API tokens**

  ```mdx
  <DashButton url="/?to=/:account/api-tokens" />
  ```

* **Manage account > Audit logs**

  ```mdx
  <DashButton url="/?to=/:account/audit-log" />
  ```

* **Manage account > Notifications**

  ```mdx
  <DashButton url="/?to=/:account/notifications" />
  ```

* **Manage account > Blocked content**

  ```mdx
  <DashButton url="/?to=/:account/blocked-content" />
  ```

* **Manage account > Abuse reports**

  ```mdx
  <DashButton url="/?to=/:account/abuse-reports" />
  ```

* **Manage account > Carbon Impact Report**

  ```mdx
  <DashButton url="/?to=/:account/carbon" />
  ```

* **Manage account > Settings**

  ```mdx
  <DashButton url="/?to=/:account/configurations" />
  ```

* **Overview**

  ```mdx
  <DashButton url="/?to=/:account/:zone/" />
  ```

* **Recents**

  ```mdx
  <DashButton url="N/A" />
  ```

* **AI Crawl Control**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ai" />
  ```

* **Log Explorer > Log search**

  ```mdx
  <DashButton url="/?to=/:account/:zone/log-explorer/log-search" />
  ```

* **Log Explorer > Custom dashboards**

  ```mdx
  <DashButton url="/?to=/:account/:zone/log-explorer/dashboards" />
  ```

* **Log Explorer > Manage datasets**

  ```mdx
  <DashButton url="/?to=/:account/:zone/log-explorer/manage-sources" />
  ```

* **Analytics & logs > HTTP Traffic**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/traffic" />
  ```

* **Analytics & logs > Web analytics**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/web/overview" />
  ```

* **Analytics & logs > Security**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/security" />
  ```

* **Analytics & logs > Performance**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/performance" />
  ```

* **Analytics & logs > Edge Reachability**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/edgeReachability" />
  ```

* **Analytics & logs > Workers**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/workers" />
  ```

* **Analytics & logs > Logpush**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/logs" />
  ```

* **Analytics & logs > Instant Logs**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/instant-logs" />
  ```

* **Version Management**

  ```mdx
  <DashButton url="/?to=/:account/:zone/versioning" />
  ```

* **DNS > Records**

  ```mdx
  <DashButton url="/?to=/:account/:zone/dns/records" />
  ```

* **DNS > Analytics**

  ```mdx
  <DashButton url="/?to=/:account/:zone/dns/analytics" />
  ```

* **DNS > Settings**

  ```mdx
  <DashButton url="/?to=/:account/:zone/dns/settings" />
  ```

* **Email > Email Routing**

  ```mdx
  <DashButton url="/?to=/:account/:zone/email/routing" />
  ```

* **Email > DMARC Management**

  ```mdx
  <DashButton url="/?to=/:account/:zone/email/dmarc-management" />
  ```

* **Email > Email Security**

  ```mdx
  <DashButton url="/?to=/:account/:zone/email/security" />
  ```

* **Spectrum**

  ```mdx
  <DashButton url="/?to=/:account/:zone/spectrum" />
  ```

* **SSL/TLS > Overview**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls" />
  ```

* **SSL/TLS > Edge Certificates**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls/edge-certificates" />
  ```

* **SSL/TLS > Staging Certificates**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls/staging-certificates" />
  ```

* **SSL/TLS > Client Certificates**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls/client-certificates" />
  ```

* **SSL/TLS > Origin Server**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls/origin" />
  ```

* **SSL/TLS > Custom Hostnames**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls/custom-hostnames" />
  ```

* **Security > Overview**

  ```mdx
  <DashButton url="/?to=/:account/:zone/security/overview" />
  ```

* **Security > Analytics**

  ```mdx
  <DashButton url="/?to=/:account/:zone/security/analytics" />
  ```

* **Security > Web assets**

  ```mdx
  <DashButton url="/?to=/:account/:zone/security/web-assets" />
  ```

* **Security > Security rules**

  ```mdx
  <DashButton url="/?to=/:account/:zone/security/security-rules" />
  ```

* **Security > Settings**

  ```mdx
  <DashButton url="/?to=/:account/:zone/security/settings" />
  ```

* **Access**

  ```mdx
  <DashButton url="/?to=/:account/:zone/access" />
  ```

* **Speed > Observatory**

  ```mdx
  <DashButton url="/?to=/:account/:zone/speed" />
  ```

* **Speed > Real user monitoring**

  ```mdx
  <DashButton url="/?to=/:account/:zone/speed/rum" />
  ```

* **Speed > Synthetic monitoring**

  ```mdx
  <DashButton url="/?to=/:account/:zone/speed/test" />
  ```

* **Speed > Settings**

  ```mdx
  <DashButton url="/?to=/:account/:zone/speed/optimization" />
  ```

* **Speed > Smart Shield**

  ```mdx
  <DashButton url="/?to=/:account/:zone/speed/smart-shield" />
  ```

* **Caching > Overview**

  ```mdx
  <DashButton url="/?to=/:account/:zone/caching" />
  ```

* **Caching > Configuration**

  ```mdx
  <DashButton url="/?to=/:account/:zone/caching/configuration" />
  ```

* **Caching > Cache Rules**

  ```mdx
  <DashButton url="/?to=/:account/:zone/caching/cache-rules" />
  ```

* **Caching > Tiered Cache**

  ```mdx
  <DashButton url="/?to=/:account/:zone/caching/tiered-cache" />
  ```

* **Caching > Cache Reserve**

  ```mdx
  <DashButton url="/?to=/:account/:zone/caching/cache-reserve" />
  ```

* **Workers Routes**

  ```mdx
  <DashButton url="/?to=/:account/:zone/workers" />
  ```

* **Rules > Overview**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/overview" />
  ```

* **Rules > Snippets**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/snippets" />
  ```

* **Rules > Cloud Connector**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/cloud-connector" />
  ```

* **Rules > Trace**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/trace/search" />
  ```

* **Rules > Page Rules**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/page-rules" />
  ```

* **Rules > Settings**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/settings" />
  ```

* **Error Pages**

  ```mdx
  <DashButton url="/?to=/:account/:zone/error-pages" />
  ```

* **Network**

  ```mdx
  <DashButton url="/?to=/:account/:zone/network" />
  ```

* **Traffic > Argo Smart Routing**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic" />
  ```

* **Traffic > Load Balancing**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic/load-balancing" />
  ```

* **Traffic > Load Balancing Analytics**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic/load-balancing-analytics" />
  ```

* **Traffic > Health Checks**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic/health-checks" />
  ```

* **Traffic > Health Check Analytics**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic/health-check-analytics" />
  ```

* **Traffic > Waiting Room**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic/waiting-rooms" />
  ```

* **Scrape Shield**

  ```mdx
  <DashButton url="/?to=/:account/:zone/content-protection" />
  ```

* **Web3**

  ```mdx
  <DashButton url="/?to=/:account/:zone/web3" />
  ```

* **Configurations**

  ```mdx
  <DashButton url="/profile/managed-profile" />
  ```

* **API Tokens**

  ```mdx
  <DashButton url="/profile/api-tokens" />
  ```

* **Active sessions**

  ```mdx
  <DashButton url="/profile/sessions" />
  ```

* **Organizations**

  ```mdx
  <DashButton url="/organizations" />
  ```

* **Accounts**

  ```mdx
  <DashButton url="/" />
  ```

* **Websites**

  ```mdx
  <DashButton url="/zones" />
  ```

* **My Profile**

  ```mdx
  <DashButton url="/profile" />
  ```

* **Tenants**

  ```mdx
  <DashButton url="/partners/tenant" />
  ```

### Zero Trust Routes

* **Access settings**

  ```mdx
  <DashButton url="/?to=/:account/access-controls/settings" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access-controls/settings/app-launcher" />
  ```

* **Targets**

  ```mdx
  <DashButton url="/?to=/:account/access-controls/targets" />
  ```

* **AI controls**

  ```mdx
  <DashButton url="/?to=/:account/access/ai-controls" />
  ```

* **AI controls**

  ```mdx
  <DashButton url="/?to=/:account/access/ai-controls/mcp-server" />
  ```

* **AI controls**

  ```mdx
  <DashButton url="/?to=/:account/access/ai-controls/mcp-server-portal" />
  ```

* **Applications**

  ```mdx
  <DashButton url="/?to=/:account/access/apps" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/apps/add" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/apps/bookmark" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/apps/edit" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/apps/infra" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/apps/mcp" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/apps/policy-tester" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/apps/private-policy-rules" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/apps/rules" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/apps/saas" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/apps/self-hosted" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/groups" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/groups/add" />
  ```

* **Access**

  ```mdx
  <DashButton url="/?to=/:account/access/overview" />
  ```

* **Policies**

  ```mdx
  <DashButton url="/?to=/:account/access/policies" />
  ```

* **Policies**

  ```mdx
  <DashButton url="/?to=/:account/access/policies/add" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/rule-groups" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/rule-groups/add" />
  ```

* **Service auth**

  ```mdx
  <DashButton url="/?to=/:account/access/service-auth" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/service-auth/mtls" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/service-auth/service-tokens" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/tags" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/access/tags/add" />
  ```

* **Tunnels**

  ```mdx
  <DashButton url="/?to=/:account/access/tunnels" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/ai-playground" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/analytics/access/viewall" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/analytics/categorieslist" />
  ```

* **Dashboards**

  ```mdx
  <DashButton url="/?to=/:account/analytics/dashboards" />
  ```

* **Access event analytics**

  ```mdx
  <DashButton url="/?to=/:account/analytics/dashboards/access-event" />
  ```

* **Application Access report**

  ```mdx
  <DashButton url="/?to=/:account/analytics/dashboards/access-report" />
  ```

* **AI security report**

  ```mdx
  <DashButton url="/?to=/:account/analytics/dashboards/ai-security-report" />
  ```

* **Data security analytics**

  ```mdx
  <DashButton url="/?to=/:account/analytics/dashboards/data-security" />
  ```

* **DNS query analytics**

  ```mdx
  <DashButton url="/?to=/:account/analytics/dashboards/dns-query" />
  ```

* **HTTP request analytics**

  ```mdx
  <DashButton url="/?to=/:account/analytics/dashboards/http-request" />
  ```

* **Network session analytics**

  ```mdx
  <DashButton url="/?to=/:account/analytics/dashboards/network-session" />
  ```

* **Shadow IT: SaaS analytics**

  ```mdx
  <DashButton url="/?to=/:account/analytics/dashboards/shadow-it-analytics" />
  ```

* **Shadow IT: Private Network analytics**

  ```mdx
  <DashButton url="/?to=/:account/analytics/dashboards/shadow-it-private-network" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/analytics/discovery/privatenetwork" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/analytics/discovery/shadowit" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/analytics/domainlist" />
  ```

* **Analytics**

  ```mdx
  <DashButton url="/?to=/:account/analytics/overview" />
  ```

* **Browser isolation**

  ```mdx
  <DashButton url="/?to=/:account/browser-isolation/overview" />
  ```

* **Content Findings**

  ```mdx
  <DashButton url="/?to=/:account/casb/content" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/casb/integration" />
  ```

* **CASB**

  ```mdx
  <DashButton url="/?to=/:account/casb/overview" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/casb/posture" />
  ```

* **DEX**

  ```mdx
  <DashButton url="/?to=/:account/dex" />
  ```

* **Monitoring**

  ```mdx
  <DashButton url="/?to=/:account/dex/monitoring" />
  ```

* **Connectivity Heat Map**

  ```mdx
  <DashButton url="/?to=/:account/dex/monitoring/devices-by-colo" />
  ```

* **Connectivity Heat Map**

  ```mdx
  <DashButton url="/?to=/:account/dex/monitoring/devices-by-colo-list" />
  ```

* **HTTP Test Details**

  ```mdx
  <DashButton url="/?to=/:account/dex/monitoring/http-tests" />
  ```

* **Monitoring**

  ```mdx
  <DashButton url="/?to=/:account/dex/monitoring/remote-captures" />
  ```

* **Monitoring**

  ```mdx
  <DashButton url="/?to=/:account/dex/monitoring/tests" />
  ```

* **Traceroute test details**

  ```mdx
  <DashButton url="/?to=/:account/dex/monitoring/traceroute-tests" />
  ```

* **Remote captures**

  ```mdx
  <DashButton url="/?to=/:account/dex/remote-captures" />
  ```

* **Start a capture**

  ```mdx
  <DashButton url="/?to=/:account/dex/remote-captures/create" />
  ```

* **Warp Diagnostic**

  ```mdx
  <DashButton url="/?to=/:account/dex/remote-captures/warp-diagnostic" />
  ```

* **Tests using a DEX rule**

  ```mdx
  <DashButton url="/?to=/:account/dex/rules" />
  ```

* **Create a DEX rule**

  ```mdx
  <DashButton url="/?to=/:account/dex/rules/create" />
  ```

* **Tests**

  ```mdx
  <DashButton url="/?to=/:account/dex/tests" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/dex/tests/add" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/dex/tests/edit" />
  ```

* **Data loss prevention**

  ```mdx
  <DashButton url="/?to=/:account/dlp" />
  ```

* **Detection entries**

  ```mdx
  <DashButton url="/?to=/:account/dlp/detection-entries" />
  ```

* **Edit dataset**

  ```mdx
  <DashButton url="/?to=/:account/dlp/detection-entries/dataset" />
  ```

* **Edit document**

  ```mdx
  <DashButton url="/?to=/:account/dlp/detection-entries/document" />
  ```

* **Edit prompt topics**

  ```mdx
  <DashButton url="/?to=/:account/dlp/detection-entries/prompt-topics" />
  ```

* **Overview**

  ```mdx
  <DashButton url="/?to=/:account/dlp/overview" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/dlp/profiles" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/dlp/profiles/create" />
  ```

* **Email Security**

  ```mdx
  <DashButton url="/?to=/:account/email-security" />
  ```

* **Group Details**

  ```mdx
  <DashButton url="/?to=/:account/email-security/directories" />
  ```

* **Email details**

  ```mdx
  <DashButton url="/?to=/:account/email-security/investigation" />
  ```

* **Retro scan email details**

  ```mdx
  <DashButton url="/?to=/:account/email-security/investigation/retro-scan" />
  ```

* **Monitoring**

  ```mdx
  <DashButton url="/?to=/:account/email-security/monitoring" />
  ```

* **Edit policy**

  ```mdx
  <DashButton url="/?to=/:account/email-security/outbound-dlp/rules" />
  ```

* **Overview**

  ```mdx
  <DashButton url="/?to=/:account/email-security/overview" />
  ```

* **Retro Scan wizard**

  ```mdx
  <DashButton url="/?to=/:account/email-security/overview/generate-retro-scan" />
  ```

* **Retro scan overview report**

  ```mdx
  <DashButton url="/?to=/:account/email-security/overview/retro-scan-report" />
  ```

* **Email Security set up**

  ```mdx
  <DashButton url="/?to=/:account/email-security/overview/setup" />
  ```

* **PhishGuard**

  ```mdx
  <DashButton url="/?to=/:account/email-security/phishguard" />
  ```

* **Reclassifications**

  ```mdx
  <DashButton url="/?to=/:account/email-security/reclassifications" />
  ```

* **Settings**

  ```mdx
  <DashButton url="/?to=/:account/email-security/settings" />
  ```

* **Domains**

  ```mdx
  <DashButton url="/?to=/:account/email-security/settings/domains" />
  ```

* **Email policy**

  ```mdx
  <DashButton url="/?to=/:account/email-security/settings/email-policy" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/gateway" />
  ```

* **Egress policies**

  ```mdx
  <DashButton url="/?to=/:account/gateway/egress-policies" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/gateway/locations" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/gateway/locations/add" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/gateway/locations/add-non-authed" />
  ```

* **Gateway**

  ```mdx
  <DashButton url="/?to=/:account/gateway/overview" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/gateway/policies" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/gateway/proxy-endpoints" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/gateway/proxy-endpoints/add" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/gateway/resolver-policies" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/gateway/resolver-policies/add" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/dns-filtering" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/dns-filtering-preface" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/replace-my-vpn" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/replace-my-vpn/device-to-device" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/replace-my-vpn/device-to-network" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/replace-my-vpn/network-to-network" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/secure-private-apps" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/secure-private-apps/clientless-rdp" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/secure-private-apps/clientless-ssh" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/secure-private-apps/private-web-app" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/secure-web-traffic" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/get-started/secure-web-traffic-preface" />
  ```

* **Zero Trust Home**

  ```mdx
  <DashButton url="/?to=/:account/home" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/home/quick-start" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/home/recent-searches/cloudy" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/home/recent-searches/index" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/home/recent-searches/resources" />
  ```

* **Insights**

  ```mdx
  <DashButton url="/?to=/:account/insights" />
  ```

* **Dashboards**

  ```mdx
  <DashButton url="/?to=/:account/insights/dashboards" />
  ```

* **Digital experience**

  ```mdx
  <DashButton url="/?to=/:account/insights/dex" />
  ```

* **Tests using a DEX rule**

  ```mdx
  <DashButton url="/?to=/:account/insights/dex/rules" />
  ```

* **Traceroute test details**

  ```mdx
  <DashButton url="/?to=/:account/insights/dex/tests" />
  ```

* **Logs**

  ```mdx
  <DashButton url="/?to=/:account/insights/logs" />
  ```

* **SSH**

  ```mdx
  <DashButton url="/?to=/:account/insights/logs/ssh" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/insights/magic-networking/*" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/insights/network-visibility/*" />
  ```

* **Network visibility**

  ```mdx
  <DashButton url="/?to=/:account/insights/network-visibility/network-overview" />
  ```

* **Network visibility**

  ```mdx
  <DashButton url="/?to=/:account/insights/network-visibility/wan-connector-health" />
  ```

* **Insights**

  ```mdx
  <DashButton url="/?to=/:account/insights/overview" />
  ```

* **Integrations**

  ```mdx
  <DashButton url="/?to=/:account/integrations" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/integrations/cloud-and-saas" />
  ```

* **Cloud & SaaS**

  ```mdx
  <DashButton url="/?to=/:account/integrations/cloud-and-saas/compute-accounts" />
  ```

* **Cloud & SaaS**

  ```mdx
  <DashButton url="/?to=/:account/integrations/cloud-and-saas/integrations" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/integrations/cloud-and-saas/new" />
  ```

* **Identity providers**

  ```mdx
  <DashButton url="/?to=/:account/integrations/identity-providers" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/integrations/identity-providers/add" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/integrations/identity-providers/edit" />
  ```

* **Service providers**

  ```mdx
  <DashButton url="/?to=/:account/integrations/service-providers" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/integrations/service-providers/add" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/integrations/service-providers/edit" />
  ```

* **Logs**

  ```mdx
  <DashButton url="/?to=/:account/logs" />
  ```

* **Access**

  ```mdx
  <DashButton url="/?to=/:account/logs/access" />
  ```

* **Admin**

  ```mdx
  <DashButton url="/?to=/:account/logs/admin" />
  ```

* **Gateway**

  ```mdx
  <DashButton url="/?to=/:account/logs/gateway" />
  ```

* **Logpush**

  ```mdx
  <DashButton url="/?to=/:account/logs/logpush" />
  ```

* **Posture**

  ```mdx
  <DashButton url="/?to=/:account/logs/posture" />
  ```

* **SCIM provisioning**

  ```mdx
  <DashButton url="/?to=/:account/logs/scim" />
  ```

* **Connectors**

  ```mdx
  <DashButton url="/?to=/:account/networks/connectors" />
  ```

* **Connectors**

  ```mdx
  <DashButton url="/?to=/:account/networks/connectors/wan-connectors" />
  ```

* **Networks**

  ```mdx
  <DashButton url="/?to=/:account/networks/overview" />
  ```

* **Resolvers & Proxies**

  ```mdx
  <DashButton url="/?to=/:account/networks/resolvers-proxies" />
  ```

* **Resolvers & Proxies**

  ```mdx
  <DashButton url="/?to=/:account/networks/resolvers-proxies/pac-file" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/networks/routes" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/networks/routes/add" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/networks/routes/hostname-routes" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/networks/routes/vnet" />
  ```

* **Targets**

  ```mdx
  <DashButton url="/?to=/:account/networks/targets" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/networks/tunnels" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/networks/tunnels/add" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/networks/tunnels/new" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/no-permissions" />
  ```

* **CASB OAuth**

  ```mdx
  <DashButton url="/?to=/:account/oauth" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/onboarding" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/onboarding/proxy" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/onboarding/warp" />
  ```

* **Overview**

  ```mdx
  <DashButton url="/?to=/:account/overview" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/recent-searches" />
  ```

* **Browser isolation settings**

  ```mdx
  <DashButton url="/?to=/:account/remote-browser-isolation/settings" />
  ```

* **Reusable components**

  ```mdx
  <DashButton url="/?to=/:account/reusable-components" />
  ```

* **Posture checks**

  ```mdx
  <DashButton url="/?to=/:account/reusable-components/posture-checks" />
  ```

* **Posture checks**

  ```mdx
  <DashButton url="/?to=/:account/reusable-components/posture-checks/service-provider" />
  ```

* **Risk score**

  ```mdx
  <DashButton url="/?to=/:account/risk-score" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/risk-score/behaviors" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/risk-score/scoring" />
  ```

* **Settings**

  ```mdx
  <DashButton url="/?to=/:account/settings" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/account" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/account/payment" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/account/plan" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/authentication" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/authentication/app-launcher" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/browser" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/browser/permissions" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/custom_pages" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/custom_pages/block_page" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/custom_pages/custom_app_launcher" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/custom_pages/custom_block" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/custom_pages/custom_login" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/custom_pages/page_templates" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/devices" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/devices/device-posture" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/devices/edit" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/devices/profile-settings" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/network" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/resources" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/resources/certificates" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/saas_integrations" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/settings/saas_integrations/new" />
  ```

* **My team**

  ```mdx
  <DashButton url="/?to=/:account/team" />
  ```

* **Team & Resources**

  ```mdx
  <DashButton url="/?to=/:account/team-resources" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/team-resources/application-library" />
  ```

* **Traceroute Test Results**

  ```mdx
  <DashButton url="/?to=/:account/team-resources/devices" />
  ```

* **Device Profiles**

  ```mdx
  <DashButton url="/?to=/:account/team-resources/devices/device-profiles" />
  ```

* **Managed Networks**

  ```mdx
  <DashButton url="/?to=/:account/team-resources/devices/managed-networks" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/team-resources/users" />
  ```

* **Users**

  ```mdx
  <DashButton url="/?to=/:account/team-resources/users/risk-score" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/team/application-library" />
  ```

* **Traceroute Test Results**

  ```mdx
  <DashButton url="/?to=/:account/team/devices" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/team/lists" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/team/lists/addCSV" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/team/lists/addManual" />
  ```

* ****

  ```mdx
  <DashButton url="/?to=/:account/team/users" />
  ```

* **Traffic settings**

  ```mdx
  <DashButton url="/?to=/:account/traffic-policies/traffic-settings" />
  ```

* **CASB OAuth**

  ```mdx
  <DashButton url="/?to=/oauth" />
  ```
