---
title: Configure Cloudflare Notifications · Cloudflare Notifications docs
description: The list of notifications available depends on the type of account
  you have. Refer to Available Notifications to learn more about what each
  notification does and what do to when receiving one.
lastUpdated: 2025-09-04T16:00:58.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/notifications/get-started/
  md: https://developers.cloudflare.com/notifications/get-started/index.md
---

The list of notifications available depends on the type of account you have. Refer to [Available Notifications](https://developers.cloudflare.com/notifications/notification-available/) to learn more about what each notification does and what do to when receiving one.

You can check the [Notification History](https://developers.cloudflare.com/notifications/notification-history/) using the API to view notifications that have been generated for your account.

## Permissions

To create a notification via the Cloudflare dashboard, you will need to have the Super Administrator or Administrator role.

You can also create a notification if you have the account edit role, which allows you create any type of notification.

An API token needs to have the [Notifications Read/Write permission](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) to create a notification,

Some notifications can only be created if you have a Professional, Business or Enterprise account or if you are using a particular Cloudflare product.

## Configure notifications

This guide will help you create, edit, test, or delete notifications using the Cloudflare dashboard.

### Create a notification

You can create a notification via the Cloudflare dashboard.

1. In the Cloudflare dashboard, go to the **Notifications** page.

   [Go to **Notifications**](https://dash.cloudflare.com/?to=/:account/notifications)

2. Select **Add**.

3. On the notification you want to create, choose **Select**.

4. Name the notification.

5. Enter an email address to receive the notifications.

Note

Professional and Business plans will have access to more notifications and PagerDuty. Accounts with a paid service will additionally have access to webhooks.

1. (Optional) Specify any additional options for the notification, if required. For example, some notifications require that you select one or more domains or services.
2. Select **Create**.

The browser will navigate back to the list of notifications, where the new notification will appear as **Enabled**.

### Edit a notification

You can edit existing Notifications via the Cloudflare dashboard.

1. In the Cloudflare dashboard, go to the **Notifications** page.

   [Go to **Notifications**](https://dash.cloudflare.com/?to=/:account/notifications)

2. On the notification that you want to modify, select **Edit**.

3. Make your changes as needed and select **Save**.

The browser will navigate back to the list of notifications.

### Disable or delete a notification

You can delete or disable existing Notifications via the Cloudflare dashboard.

1. In the Cloudflare dashboard, go to the **Notifications** page.

   [Go to **Notifications**](https://dash.cloudflare.com/?to=/:account/notifications)

2. On the notification that you want to disable, select the **Enabled** toggle. To delete it, select **Delete**.

### Test a notification

To verify that notifications will be sent to the correct location or to view which details are available, you can test a notification by selecting **Test** on any enabled notification.

This action sends a notification with fake data.
