---
title: Cache · Cloudflare Data Localization Suite docs
description: In the following sections, we will give you some details about how
  to configure Cache with Regional Services and Customer Metadata Boundary.
lastUpdated: 2025-10-06T13:41:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/data-localization/how-to/cache/
  md: https://developers.cloudflare.com/data-localization/how-to/cache/index.md
---

In the following sections, we will give you some details about how to configure Cache with Regional Services and Customer Metadata Boundary.

## Regional Services

To configure Regional Services for hostnames [proxied](https://developers.cloudflare.com/dns/proxy-status/) through Cloudflare and ensure that [eligible assets](https://developers.cloudflare.com/cache/concepts/default-cache-behavior/) are cached only in-region, follow these steps for the dashboard or API configuration:

* Dashboard

  1. In the Cloudflare dashboard, go to the **Records** page.

     [Go to **Records**](https://dash.cloudflare.com/?to=/:account/:zone/dns/records)

  2. Follow these steps to [create a DNS record](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/).

  3. From the **Region** dropdown, select the region you would like to use on your domain.

  4. Select **Save**.

* API

  1. To create records with the API, use the [API POST](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/create/) command.
  2. Run the [API POST](https://developers.cloudflare.com/data-localization/regional-services/get-started/#configure-regional-services-via-api) command on the hostname to create a `regional_hostnames` with a specific region.

Note

Take into consideration that only [Generic Global Tiered Cache](https://developers.cloudflare.com/cache/how-to/tiered-cache/#generic-global-tiered-cache) and [Custom Tiered Cache](https://developers.cloudflare.com/cache/how-to/tiered-cache/#custom-tiered-cache) respect Regional Services. [Smart Tiered Cache](https://developers.cloudflare.com/cache/how-to/tiered-cache/#smart-tiered-cache) is incompatible with Regional Services.

## Customer Metadata Boundary

[Cache Analytics](https://developers.cloudflare.com/cache/performance-review/cache-analytics/), Generic Global Tiered Cache and Custom Tiered Cache are compatible with Customer Metadata Boundary. With Customer Metadata Boundary set to EU, the **Caching** > **Tiered Cache** tab in the zone dashboard will not be populated.

For more information on CDN and caching, refer to the [Cache documentation](https://developers.cloudflare.com/cache/).
