---
title: Python Workers handlers now live in an entrypoint class · Changelog
description: We are changing how Python Workers are structured by default.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-08-14-new-python-handlers/
  md: https://developers.cloudflare.com/changelog/2025-08-14-new-python-handlers/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Python Workers handlers now live in an entrypoint class

Aug 14, 2025

[Workers](https://developers.cloudflare.com/workers/)

We are changing how Python Workers are structured by default. Previously, handlers were defined at the top-level of a module as `on_fetch`, `on_scheduled`, etc. methods, but now they live in an entrypoint class.

Here's an example of how to now define a Worker with a fetch handler:

```python
from workers import Response, WorkerEntrypoint


class Default(WorkerEntrypoint):
    async def fetch(self, request):
        return Response("Hello World!")
```

To keep using the old-style handlers, you can specify the `disable_python_no_global_handlers` compatibility flag in your wrangler file:

* wrangler.jsonc

  ```jsonc
  {
    "$schema": "./node_modules/wrangler/config-schema.json",
    "compatibility_flags": [
      "disable_python_no_global_handlers"
    ]
  }
  ```

* wrangler.toml

  ```toml
  compatibility_flags = [ "disable_python_no_global_handlers" ]
  ```

Consult the [Python Workers documentation](https://developers.cloudflare.com/workers/languages/python/) for more details.
