---
title: Certificate Transparency Insights in Cloudflare Radar · Changelog
description: New Certificate Transparency (CT) insights in Cloudflare Radar,
  with new API endpoints for certificate issuance trends
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-08-04-radar-ct-insights/
  md: https://developers.cloudflare.com/changelog/2025-08-04-radar-ct-insights/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Certificate Transparency Insights in Cloudflare Radar

Aug 06, 2025

[Radar](https://developers.cloudflare.com/radar/)

[**Radar**](https://developers.cloudflare.com/radar/) now introduces Certificate Transparency (CT) insights, providing visibility into certificate issuance trends based on Certificate Transparency logs currently monitored by Cloudflare.

The following API endpoints are now available:

* [`/ct/timeseries`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/methods/timeseries/): Retrieves certificate issuance time series.
* [`/ct/summary/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/methods/summary/): Retrieves certificate distribution by dimension.
* [`/ct/timeseries_groups/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/methods/timeseries_groups/): Retrieves time series of certificate distribution by dimension.
* [`/ct/authorities`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/subresources/authorities/methods/list/): Lists certification authorities.
* [`/ct/authorities/{ca_slug}`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/subresources/authorities/methods/get/): Retrieves details about a Certification Authority (CA). CA information is derived from the [Common CA Database (CCADB)](https://www.ccadb.org/).
* [`/ct/logs`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/subresources/logs/methods/list/): Lists CT logs.
* [`/ct/logs/{log_slug}`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/subresources/logs/methods/get/): Retrieves details about a CT log. CT log information is derived from the [Google Chrome log list](https://googlechrome.github.io/CertificateTransparency/log_lists.html).

For the `summary` and `timeseries_groups` endpoints, the following dimensions are available (and also usable as filters):

* `ca`: Certification Authority (certificate issuer)
* `ca_owner`: Certification Authority Owner
* `duration`: Certificate validity duration (between NotBefore and NotAfter dates)
* `entry_type`: Entry type (certificate vs. pre-certificate)
* `expiration_status`: Expiration status (valid vs. expired)
* `has_ips`: Presence of IP addresses in certificate [Subject Alternative Names (SANs)](https://developers.cloudflare.com/ssl/origin-configuration/origin-ca/#hostname-and-wildcard-coverage)
* `has_wildcards`: Presence of wildcard DNS names in certificate SANs
* `log`: CT log name
* `log_api`: CT log API ([RFC6962](https://datatracker.ietf.org/doc/html/rfc6962) vs. [Static](https://c2sp.org/static-ct-api))
* `log_operator`: CT log operator
* `public_key_algorithm`: Public key algorithm of certificate's key
* `signature_algorithm`: Signature algorithm used by CA to sign certificate
* `tld`: Top-level domain for DNS names found in certificates SANs
* `validation_level`: [Validation level](https://www.cloudflare.com/learning/ssl/types-of-ssl-certificates/)

Check out the new Certificate Transparency insights in the [new Radar page](https://radar.cloudflare.com/certificate-transparency).
