---
title: Leaked Credentials Insights in Cloudflare Radar · Changelog
description: Expanded security insights with new API endpoints for aggregated
  authentication request data
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-03-18-radar-leaked-credentials-insights/
  md: https://developers.cloudflare.com/changelog/2025-03-18-radar-leaked-credentials-insights/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Leaked Credentials Insights in Cloudflare Radar

Mar 18, 2025

[Radar](https://developers.cloudflare.com/radar/)

[**Radar**](https://developers.cloudflare.com/radar/) has expanded its security insights, providing visibility into aggregate trends in authentication requests, including the detection of leaked credentials through [leaked credentials detection](https://developers.cloudflare.com/waf/detections/leaked-credentials/) scans.

We have now introduced the following endpoints:

* [`/leaked_credential_checks/summary/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/leaked_credentials/subresources/summary/): Retrieves summaries of HTTP authentication requests distribution across two different dimensions.
* [`/leaked_credential_checks/timeseries_groups/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/leaked_credentials/subresources/timeseries_groups/): Retrieves timeseries data for HTTP authentication requests distribution across two different dimensions.

The following dimensions are available, displaying the distribution of HTTP authentication requests based on:

* `compromised`: Credential status (clean vs. compromised).
* `bot_class`: [Bot class](https://developers.cloudflare.com/radar/concepts/bot-classes) (human vs. bot).

Dive deeper into leaked credential detection in this [blog post](https://blog.cloudflare.com/password-reuse-rampant-half-user-logins-compromised/) and learn more about the expanded Radar security insights in our [blog post](https://blog.cloudflare.com/cloudflare-radar-ddos-leaked-credentials-bots).
