---
title: Bringing Your Own IPs to Cloudflare · Cloudflare BYOIP docs
description: Get Cloudflare's security and performance while using your own IPs.
lastUpdated: 2025-11-21T18:29:21.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/byoip/
  md: https://developers.cloudflare.com/byoip/index.md
---

Get Cloudflare's security and performance while using your own IPs.

Enterprise-only

Considering [how Cloudflare works as a reverse proxy](https://developers.cloudflare.com/fundamentals/concepts/how-cloudflare-works/), for some customers it may be important to maintain this functionality while also keeping their website or application associated with their own public IP space (instead of Cloudflare's[1](#user-content-fn-1)).

With Bring Your Own IP (BYOIP), Cloudflare announces your IPs in all our locations. Use your IPs with [Magic Transit](https://developers.cloudflare.com/magic-transit/), [Spectrum](https://developers.cloudflare.com/spectrum/), [CDN services](https://developers.cloudflare.com/cache/), or Gateway [DNS locations](https://developers.cloudflare.com/cloudflare-one/networks/resolvers-and-proxies/dns/locations/) and [dedicated egress IPs](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/dedicated-egress-ips/).

Learn how to [get started](https://developers.cloudflare.com/byoip/get-started/).

***

## Features

### Service bindings

Control whether traffic destined for a given IP address is routed to Magic Transit, CDN, or Spectrum.

[Use Service bindings](https://developers.cloudflare.com/byoip/service-bindings/)

### Address maps

Specify which IP addresses should be mapped to DNS records when they are proxied through Cloudflare.

[Use Address maps](https://developers.cloudflare.com/byoip/address-maps/)

***

## More resources

[RPKI blog post](https://blog.cloudflare.com/rpki/)

An overview of BGP, RPKI, and other important aspects of Internet routing.

[Reference Architectures](https://developers.cloudflare.com/reference-architecture/)

Explore how you can leverage Cloudflare's platform to create solutions based on your business needs.

## Footnotes

1. Without BYOIP, when your domain's records are `proxied`, Cloudflare responds with a Cloudflare-owned [anycast IP address](https://developers.cloudflare.com/fundamentals/concepts/cloudflare-ip-addresses/). [↩](#user-content-fnref-1)
